// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Inftpserver.pas' rev: 10.00

#ifndef InftpserverHPP
#define InftpserverHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inassignednumbers.hpp>	// Pascal unit
#include <Incommandhandlers.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Incontext.hpp>	// Pascal unit
#include <Inexception.hpp>	// Pascal unit
#include <Inexplicittlsclientserverbase.hpp>	// Pascal unit
#include <Inftpbasefilesystem.hpp>	// Pascal unit
#include <Inftpcommon.hpp>	// Pascal unit
#include <Inftplist.hpp>	// Pascal unit
#include <Inftplistoutput.hpp>	// Pascal unit
#include <Inftpservercontextbase.hpp>	// Pascal unit
#include <Inreply.hpp>	// Pascal unit
#include <Inreplyftp.hpp>	// Pascal unit
#include <Inreplyrfc.hpp>	// Pascal unit
#include <Inscheduler.hpp>	// Pascal unit
#include <Inserveriohandler.hpp>	// Pascal unit
#include <Intcpconnection.hpp>	// Pascal unit
#include <Incmdtcpserver.hpp>	// Pascal unit
#include <Intcpserver.hpp>	// Pascal unit
#include <Inthread.hpp>	// Pascal unit
#include <Inuseraccounts.hpp>	// Pascal unit
#include <Inyarn.hpp>	// Pascal unit
#include <Inzlibcompressorbase.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Intask.hpp>	// Pascal unit
#include <Incomponent.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Inftpserver
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TInFTPDirFormat { ftpdfDOS, ftpdfUnix, ftpdfEPLF, ftpdfCustom, ftpdfOSDependent };
#pragma option pop

#pragma option push -b-
enum TInFTPPathProcessing { ftppDOS, ftppUnix, ftpOSDependent, ftppCustom };
#pragma option pop

#pragma option push -b-
enum TInFTPOperation { ftpRetr, ftpStor };
#pragma option pop

#pragma option push -b-
enum TIdMLSDAttr { mlsdUniqueID, mlsdPerms, mlsdUnixModes, mlsdFileCreationTime };
#pragma option pop

typedef Set<TIdMLSDAttr, mlsdUniqueID, mlsdFileCreationTime>  TIdMLSDAttrs;

typedef AnsiString InFTPServer__1[3];

class DELPHICLASS TInFTPServerContext;
typedef void __fastcall (__closure *TOnDataPortBind)(TInFTPServerContext* ASender);

typedef void __fastcall (__closure *TOnSiteUMASK)(TInFTPServerContext* ASender, int &VUMASK, bool &VAUth);

typedef void __fastcall (__closure *TOnSiteCHMOD)(TInFTPServerContext* ASender, const int APermissions, const AnsiString AFileName, bool &VAUth);

typedef void __fastcall (__closure *TOnCustomPathProcess)(TInFTPServerContext* ASender, AnsiString &VPath);

typedef void __fastcall (__closure *TOnUserLoginEvent)(TInFTPServerContext* ASender, const AnsiString AUsername, const AnsiString APassword, bool &AAuthenticated);

typedef void __fastcall (__closure *TOnAfterUserLoginEvent)(TInFTPServerContext* ASender);

typedef void __fastcall (__closure *TOnDirectoryEvent)(TInFTPServerContext* ASender, AnsiString &VDirectory);

typedef void __fastcall (__closure *TOnGetFileSizeEvent)(TInFTPServerContext* ASender, const AnsiString AFilename, __int64 &VFileSize);

typedef void __fastcall (__closure *TOnGetFileDateEvent)(TInFTPServerContext* ASender, const AnsiString AFilename, System::TDateTime &VFileDate);

typedef void __fastcall (__closure *TOnListDirectoryEvent)(TInFTPServerContext* ASender, const AnsiString APath, Inftplistoutput::TInFTPListOutput* ADirectoryListing, const AnsiString ACmd, const AnsiString ASwitches);

typedef void __fastcall (__closure *TOnCustomListDirectoryEvent)(TInFTPServerContext* ASender, const AnsiString APath, Classes::TStrings* ADirectoryListing, const AnsiString ACmd, const AnsiString ASwitches);

typedef void __fastcall (__closure *TOnFileEvent)(TInFTPServerContext* ASender, const AnsiString APathName);

typedef void __fastcall (__closure *TOnCheckFileEvent)(TInFTPServerContext* ASender, const AnsiString APathName, bool &VExist);

typedef void __fastcall (__closure *TOnRenameFileEvent)(TInFTPServerContext* ASender, const AnsiString ARenameFromFile, const AnsiString ARenameToFile);

typedef void __fastcall (__closure *TOnRetrieveFileEvent)(TInFTPServerContext* ASender, const AnsiString AFileName, Classes::TStream* &VStream);

typedef void __fastcall (__closure *TOnStoreFileEvent)(TInFTPServerContext* ASender, const AnsiString AFileName, bool AAppend, Classes::TStream* &VStream);

typedef void __fastcall (__closure *TOnCombineFiles)(TInFTPServerContext* ASender, const AnsiString ATargetFileName, Classes::TStrings* AParts);

typedef void __fastcall (__closure *TOnCheckSumFile)(TInFTPServerContext* ASender, const AnsiString AFileName, Classes::TStream* &VStream);

typedef void __fastcall (__closure *TOnCacheChecksum)(TInFTPServerContext* ASender, const AnsiString AFileName, AnsiString &VCheckSum);

typedef void __fastcall (__closure *TOnVerifyChecksum)(TInFTPServerContext* ASender, const AnsiString AFileName, const AnsiString ACheckSum);

typedef void __fastcall (__closure *TOnSetFileDateEvent)(TInFTPServerContext* ASender, const AnsiString AFileName, System::TDateTime &AFileTime);

class DELPHICLASS EInFTPServerException;
class PASCALIMPLEMENTATION EInFTPServerException : public Inexception::EInException 
{
	typedef Inexception::EInException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInFTPServerException(AnsiString AMsg)/* overload */ : Inexception::EInException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInFTPServerException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EInException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInFTPServerException(int Ident)/* overload */ : Inexception::EInException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInFTPServerException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EInException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInFTPServerException(const AnsiString Msg, int AHelpContext) : Inexception::EInException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInFTPServerException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EInException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInFTPServerException(int Ident, int AHelpContext)/* overload */ : Inexception::EInException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInFTPServerException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EInException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInFTPServerException(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInFTPServerNoOnListDirectory;
class PASCALIMPLEMENTATION EInFTPServerNoOnListDirectory : public EInFTPServerException 
{
	typedef EInFTPServerException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInFTPServerNoOnListDirectory(AnsiString AMsg)/* overload */ : EInFTPServerException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInFTPServerNoOnListDirectory(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInFTPServerException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInFTPServerNoOnListDirectory(int Ident)/* overload */ : EInFTPServerException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInFTPServerNoOnListDirectory(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInFTPServerException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInFTPServerNoOnListDirectory(const AnsiString Msg, int AHelpContext) : EInFTPServerException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInFTPServerNoOnListDirectory(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInFTPServerException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInFTPServerNoOnListDirectory(int Ident, int AHelpContext)/* overload */ : EInFTPServerException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInFTPServerNoOnListDirectory(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInFTPServerException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInFTPServerNoOnListDirectory(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInFTPImplicitTLSRequiresSSL;
class PASCALIMPLEMENTATION EInFTPImplicitTLSRequiresSSL : public EInFTPServerException 
{
	typedef EInFTPServerException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInFTPImplicitTLSRequiresSSL(AnsiString AMsg)/* overload */ : EInFTPServerException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInFTPImplicitTLSRequiresSSL(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInFTPServerException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInFTPImplicitTLSRequiresSSL(int Ident)/* overload */ : EInFTPServerException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInFTPImplicitTLSRequiresSSL(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInFTPServerException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInFTPImplicitTLSRequiresSSL(const AnsiString Msg, int AHelpContext) : EInFTPServerException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInFTPImplicitTLSRequiresSSL(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInFTPServerException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInFTPImplicitTLSRequiresSSL(int Ident, int AHelpContext)/* overload */ : EInFTPServerException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInFTPImplicitTLSRequiresSSL(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInFTPServerException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInFTPImplicitTLSRequiresSSL(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInFTPBoundPortMaxGreater;
class PASCALIMPLEMENTATION EInFTPBoundPortMaxGreater : public EInFTPServerException 
{
	typedef EInFTPServerException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInFTPBoundPortMaxGreater(AnsiString AMsg)/* overload */ : EInFTPServerException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInFTPBoundPortMaxGreater(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInFTPServerException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInFTPBoundPortMaxGreater(int Ident)/* overload */ : EInFTPServerException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInFTPBoundPortMaxGreater(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInFTPServerException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInFTPBoundPortMaxGreater(const AnsiString Msg, int AHelpContext) : EInFTPServerException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInFTPBoundPortMaxGreater(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInFTPServerException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInFTPBoundPortMaxGreater(int Ident, int AHelpContext)/* overload */ : EInFTPServerException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInFTPBoundPortMaxGreater(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInFTPServerException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInFTPBoundPortMaxGreater(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInFTPBoundPortMinLess;
class PASCALIMPLEMENTATION EInFTPBoundPortMinLess : public EInFTPServerException 
{
	typedef EInFTPServerException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInFTPBoundPortMinLess(AnsiString AMsg)/* overload */ : EInFTPServerException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInFTPBoundPortMinLess(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInFTPServerException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInFTPBoundPortMinLess(int Ident)/* overload */ : EInFTPServerException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInFTPBoundPortMinLess(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInFTPServerException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInFTPBoundPortMinLess(const AnsiString Msg, int AHelpContext) : EInFTPServerException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInFTPBoundPortMinLess(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInFTPServerException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInFTPBoundPortMinLess(int Ident, int AHelpContext)/* overload */ : EInFTPServerException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInFTPBoundPortMinLess(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInFTPServerException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInFTPBoundPortMinLess(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInFTPCannotBeNegative;
class PASCALIMPLEMENTATION EInFTPCannotBeNegative : public EInFTPServerException 
{
	typedef EInFTPServerException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInFTPCannotBeNegative(AnsiString AMsg)/* overload */ : EInFTPServerException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInFTPCannotBeNegative(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInFTPServerException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInFTPCannotBeNegative(int Ident)/* overload */ : EInFTPServerException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInFTPCannotBeNegative(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInFTPServerException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInFTPCannotBeNegative(const AnsiString Msg, int AHelpContext) : EInFTPServerException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInFTPCannotBeNegative(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInFTPServerException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInFTPCannotBeNegative(int Ident, int AHelpContext)/* overload */ : EInFTPServerException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInFTPCannotBeNegative(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInFTPServerException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInFTPCannotBeNegative(void) { }
	#pragma option pop
	
};


typedef void __fastcall (__closure *TIdOnClientID)(TInFTPServerContext* ASender, const AnsiString AID);

typedef void __fastcall (__closure *TIdOnFTPStatEvent)(TInFTPServerContext* ASender, Classes::TStrings* AStatusInfo);

typedef void __fastcall (__closure *TIdOnBanner)(TInFTPServerContext* ASender, Inreply::TInReply* AGreeting);

typedef void __fastcall (__closure *TIdOnPASV)(TInFTPServerContext* ASender, AnsiString &VIP, Word &VPort, const Inglobal::TIdIPVersion VIPVer);

class DELPHICLASS TInFTPSecurityOptions;
class PASCALIMPLEMENTATION TInFTPSecurityOptions : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
protected:
	unsigned FPasswordAttempts;
	unsigned FInvalidPassDelay;
	bool FRequirePASVFromSameIP;
	bool FRequirePORTFromSameIP;
	bool FNoReservedRangePORT;
	bool FBlockAllPORTTransfers;
	bool FDisableSYSTCommand;
	bool FDisableSTATCommand;
	
public:
	__fastcall TInFTPSecurityOptions(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	
__published:
	__property unsigned PasswordAttempts = {read=FPasswordAttempts, write=FPasswordAttempts, default=3};
	__property unsigned InvalidPassDelay = {read=FInvalidPassDelay, write=FInvalidPassDelay, default=3000};
	__property bool RequirePASVFromSameIP = {read=FRequirePASVFromSameIP, write=FRequirePASVFromSameIP, default=1};
	__property bool RequirePORTFromSameIP = {read=FRequirePORTFromSameIP, write=FRequirePORTFromSameIP, default=1};
	__property bool NoReservedRangePORT = {read=FNoReservedRangePORT, write=FNoReservedRangePORT, default=1};
	__property bool BlockAllPORTTransfers = {read=FBlockAllPORTTransfers, write=FBlockAllPORTTransfers, default=0};
	__property bool DisableSYSTCommand = {read=FDisableSYSTCommand, write=FDisableSYSTCommand, default=0};
	__property bool DisableSTATCommand = {read=FDisableSTATCommand, write=FDisableSTATCommand, default=0};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TInFTPSecurityOptions(void) { }
	#pragma option pop
	
};


class DELPHICLASS TIdDataChannel;
class DELPHICLASS TInFTPServer;
class PASCALIMPLEMENTATION TInFTPServer : public Inexplicittlsclientserverbase::TIdExplicitTLSServer 
{
	typedef Inexplicittlsclientserverbase::TIdExplicitTLSServer inherited;
	
protected:
	TInFTPDirFormat FDirFormat;
	TInFTPPathProcessing FPathProcessing;
	TIdOnClientID FOnClientID;
	Incommandhandlers::TInCommandHandlers* FDataChannelCommands;
	Incommandhandlers::TInCommandHandlers* FSITECommands;
	TIdMLSDAttrs FMLSDFacts;
	Classes::TStringList* FAnonymousAccounts;
	bool FAllowAnonymousLogin;
	bool FAnonymousPassStrictCheck;
	Incommandhandlers::TIdCommandHandler* FCmdHandlerList;
	Incommandhandlers::TIdCommandHandler* FCmdHandlerNlst;
	int FPASVBoundPortMin;
	int FPASVBoundPortMax;
	AnsiString FSystemType;
	int FDefaultDataPort;
	Inuseraccounts::TIdCustomUserManager* FUserAccounts;
	TOnAfterUserLoginEvent FOnAfterUserLogin;
	TOnUserLoginEvent FOnUserLogin;
	TOnDirectoryEvent FOnChangeDirectory;
	TOnGetFileSizeEvent FOnGetFileSize;
	TOnGetFileDateEvent FOnGetFileDate;
	TOnListDirectoryEvent FOnListDirectory;
	TOnCustomListDirectoryEvent FOnCustomListDirectory;
	TOnRenameFileEvent FOnRenameFile;
	TOnFileEvent FOnDeleteFile;
	TOnRetrieveFileEvent FOnRetrieveFile;
	TOnStoreFileEvent FOnStoreFile;
	TOnDirectoryEvent FOnMakeDirectory;
	TOnDirectoryEvent FOnRemoveDirectory;
	TIdOnFTPStatEvent FOnStat;
	TInFTPSecurityOptions* FFTPSecurityOptions;
	TOnCheckSumFile FOnCRCFile;
	TOnCombineFiles FOnCombineFiles;
	TOnSetFileDateEvent FOnSetModifiedTime;
	TOnCheckFileEvent FOnFileExistCheck;
	TOnSetFileDateEvent FOnSetCreationTime;
	TOnCacheChecksum FOnMD5Cache;
	TOnVerifyChecksum FOnMD5Verify;
	TIdOnBanner FOnGreeting;
	TIdOnBanner FOnLoginSuccessBanner;
	TIdOnBanner FOnLoginFailureBanner;
	TIdOnBanner FOnQuitBanner;
	TOnSiteUMASK FOnSiteUMASK;
	TOnSiteCHMOD FOnSiteCHMOD;
	TOnCustomPathProcess FOnCustomPathProcess;
	TOnDataPortBind FOnDataPortBeforeBind;
	TOnDataPortBind FOnDataPortAfterBind;
	TIdOnPASV FOnPASV;
	Inftpbasefilesystem::TInFTPBaseFileSystem* FFTPFileSystem;
	AnsiString FEndOfHelpLine;
	AnsiString FCustomSystID;
	Inreply::TInReply* FReplyUnknownSITECommand;
	Inzlibcompressorbase::TInZLibCompressorBase* FCompressor;
	void __fastcall DoOnPASV(TInFTPServerContext* ASender, AnsiString &VIP, Word &VPort, const Inglobal::TIdIPVersion VIPVersion);
	bool __fastcall InternalPASV(Incommandhandlers::TIdCommand* ASender, AnsiString &VIP, Word &VPort, Inglobal::TIdIPVersion &VIPVersion);
	AnsiString __fastcall DoSysType(TInFTPServerContext* ASender);
	AnsiString __fastcall DoProcessPath(TInFTPServerContext* ASender, const AnsiString APath);
	AnsiString __fastcall FTPNormalizePath(const AnsiString APath);
	AnsiString __fastcall MLSFEATLine(const TIdMLSDAttrs AFactMask, const Inftplistoutput::TInFTPFactOutputs AFacts);
	AnsiString __fastcall HelpText(Classes::TStrings* Cmds);
	bool __fastcall IsValidPermNumbers(const AnsiString APermNos);
	void __fastcall SetRFCReplyFormat(Inreply::TInReply* AReply);
	AnsiString __fastcall CDUPDir(TInFTPServerContext* AContext);
	void __fastcall DisconUser(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CmdNotImplemented(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CmdFileActionAborted(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CmdSyntaxError(Incontext::TInContext* AContext, AnsiString ALine, const Inreply::TInReply* AReply = (Inreply::TInReply*)(0x0))/* overload */;
	void __fastcall CmdSyntaxError(Incommandhandlers::TIdCommand* ASender)/* overload */;
	void __fastcall CmdTwineFileActionAborted(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CmdCommandSuccessful(Incommandhandlers::TIdCommand* ASender, const int AReplyCode = 0xfa);
	void __fastcall CommandQUITTransfer(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandQUIT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandUSER(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandPASS(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandCWD(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandCDUP(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandREIN(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandPORT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandPASV(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandTYPE(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSTRU(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMODE(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandRETR(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSSAP(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandALLO(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandREST(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandRNFR(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandRNTO(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandABOR(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandDELE(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandRMD(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMKD(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandPWD(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandLIST(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSYST(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSTAT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSIZE(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandFEAT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandOPTS(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandAUTH(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandEPSV(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandEPRT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMDTM(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMFF(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMD5(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMMD5(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandPROT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandPBSZ(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMFMT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMFCT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMLSD(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandMLST(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandXMD5(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandXCRC(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandCOMB(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandCLNT(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSSCN(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandCPSV(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSPSV(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSecRFC(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSITE(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSiteHELP(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSiteUMASK(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSiteCHMOD(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSiteDIRSTYLE(Incommandhandlers::TIdCommand* ASender);
	void __fastcall CommandSiteZONE(Incommandhandlers::TIdCommand* ASender);
	void __fastcall COmmandHELP(Incommandhandlers::TIdCommand* ASender);
	void __fastcall DoOnRenameFile(TInFTPServerContext* ASender, const AnsiString ARenameFromFile, const AnsiString ARenameToFile);
	void __fastcall DoOnDeleteFile(TInFTPServerContext* ASender, const AnsiString APathName);
	void __fastcall DoOnChangeDirectory(TInFTPServerContext* AContext, AnsiString &VDirectory);
	void __fastcall DoOnMakeDirectory(TInFTPServerContext* AContext, AnsiString &VDirectory);
	void __fastcall DoOnRemoveDirectory(TInFTPServerContext* AContext, AnsiString &VDirectory);
	void __fastcall DoOnGetFileSize(TInFTPServerContext* ASender, const AnsiString AFilename, __int64 &VFileSize);
	void __fastcall DoOnGetFileDate(TInFTPServerContext* ASender, const AnsiString AFilename, System::TDateTime &VFileDate);
	void __fastcall DoOnSetModifiedTime(TInFTPServerContext* AContext, const AnsiString AFileName, System::TDateTime &VDateTime)/* overload */;
	void __fastcall DoOnSetModifiedTime(TInFTPServerContext* AContext, const AnsiString AFileName, AnsiString &VDateTimeStr)/* overload */;
	void __fastcall DoOnFileExistCheck(TInFTPServerContext* AContext, const AnsiString AFileName, bool &VExist);
	void __fastcall DoOnSetModifiedTimeGMT(TInFTPServerContext* AContext, const AnsiString AFileName, System::TDateTime &VDateTime);
	void __fastcall DoOnSetCreationTime(TInFTPServerContext* AContext, const AnsiString AFileName, System::TDateTime &VDateTime)/* overload */;
	void __fastcall DoOnSetCreationTime(TInFTPServerContext* AContext, const AnsiString AFileName, AnsiString &VDateTimeStr)/* overload */;
	void __fastcall DoOnSetCreationTimeGMT(TInFTPServerContext* AContext, const AnsiString AFileName, System::TDateTime &VDateTime);
	void __fastcall DoOnCRCFile(TInFTPServerContext* ASender, const AnsiString AFileName, Classes::TStream* &VStream);
	void __fastcall DoOnMD5Verify(TInFTPServerContext* ASender, const AnsiString AFileName, const AnsiString ACheckSum);
	void __fastcall DoOnMD5Cache(TInFTPServerContext* ASender, const AnsiString AFileName, AnsiString &VCheckSum);
	void __fastcall DoOnCombineFiles(TInFTPServerContext* ASender, const AnsiString ATargetFileName, Classes::TStrings* AParts);
	void __fastcall DoOnSiteUMASK(TInFTPServerContext* ASender, int &VUMASK, bool &VAUth);
	void __fastcall DoOnSiteCHMOD(TInFTPServerContext* ASender, const int APermissions, const AnsiString AFileName, bool &VAUth);
	void __fastcall DoOnClientID(TInFTPServerContext* ASender, const AnsiString AIDString);
	virtual void __fastcall SetUseTLS(Inexplicittlsclientserverbase::TIdUseTLS AValue);
	virtual void __fastcall InitializeCommandHandlers(void);
	void __fastcall ListDirectory(TInFTPServerContext* ASender, AnsiString ADirectory, Classes::TStringList* &ADirContents, bool ADetails, const AnsiString ACmd = "LIST", const AnsiString ASwitches = "");
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	void __fastcall SetAnonymousAccounts(const Classes::TStringList* AValue);
	void __fastcall SetUserAccounts(const Inuseraccounts::TIdCustomUserManager* AValue);
	void __fastcall SetFTPSecurityOptions(const TInFTPSecurityOptions* AValue);
	void __fastcall SetPASVBoundPortMax(const int Value);
	void __fastcall SetPASVBoundPortMin(const int Value);
	void __fastcall SetReplyUnknownSITECommand(Inreply::TInReply* AValue);
	void __fastcall SetSITECommands(Incommandhandlers::TInCommandHandlers* AValue);
	void __fastcall ThreadException(Inthread::TInThread* AThread, Sysutils::Exception* AException);
	void __fastcall SetFTPFileSystem(const Inftpbasefilesystem::TInFTPBaseFileSystem* AValue);
	AnsiString __fastcall GetMD5Checksum(TInFTPServerContext* ASender, const AnsiString AFileName);
	virtual void __fastcall DoConnect(Incontext::TInContext* AContext);
	virtual void __fastcall DoDisconnect(Incontext::TInContext* AContext);
	virtual void __fastcall ContextCreated(Incontext::TInContext* AContext);
	AnsiString __fastcall CalculateCRCHash(Classes::TStream* AStrm, const unsigned ABeginPos, const unsigned AEndPos);
	AnsiString __fastcall CalculateMD5Checksum(Classes::TStream* AStrm, const __int64 ABeginPos, const __int64 AEndPos);
	virtual void __fastcall DoOnDataPortBeforeBind(TInFTPServerContext* ASender);
	virtual void __fastcall DoDataChannelOperation(Incommandhandlers::TIdCommand* ASender, const bool AConnectMode = false);
	virtual void __fastcall DoOnDataPortAfterBind(TInFTPServerContext* ASender);
	void __fastcall DoOnCustomListDirectory(TInFTPServerContext* ASender, const AnsiString APath, Classes::TStrings* ADirectoryListing, const AnsiString ACmd, const AnsiString ASwitches);
	virtual TMetaClass* __fastcall GetReplyClass(void);
	virtual TMetaClass* __fastcall GetRepliesClass(void);
	virtual void __fastcall InitComponent(void);
	virtual void __fastcall DoReplyUnknownCommand(Incontext::TInContext* AContext, AnsiString ALine);
	virtual AnsiString __fastcall ReadCommandLine(Incontext::TInContext* AContext);
	
public:
	__fastcall virtual ~TInFTPServer(void);
	
__published:
	__property Inzlibcompressorbase::TInZLibCompressorBase* Compressor = {read=FCompressor, write=FCompressor};
	__property AnsiString CustomSystID = {read=FCustomSystID, write=FCustomSystID};
	__property TInFTPDirFormat DirFormat = {read=FDirFormat, write=FDirFormat, default=1};
	__property TInFTPPathProcessing PathProcessing = {read=FPathProcessing, write=FPathProcessing, default=2};
	__property UseTLS  = {default=0};
	__property bool AllowAnonymousLogin = {read=FAllowAnonymousLogin, write=FAllowAnonymousLogin, default=0};
	__property Classes::TStringList* AnonymousAccounts = {read=FAnonymousAccounts, write=SetAnonymousAccounts};
	__property bool AnonymousPassStrictCheck = {read=FAnonymousPassStrictCheck, write=FAnonymousPassStrictCheck, default=1};
	__property int DefaultDataPort = {read=FDefaultDataPort, write=FDefaultDataPort, default=20};
	__property Inftpbasefilesystem::TInFTPBaseFileSystem* FTPFileSystem = {read=FFTPFileSystem, write=SetFTPFileSystem};
	__property TInFTPSecurityOptions* FTPSecurityOptions = {read=FFTPSecurityOptions, write=SetFTPSecurityOptions};
	__property AnsiString EndOfHelpLine = {read=FEndOfHelpLine, write=FEndOfHelpLine};
	__property int PASVBoundPortMin = {read=FPASVBoundPortMin, write=SetPASVBoundPortMin, default=0};
	__property int PASVBoundPortMax = {read=FPASVBoundPortMax, write=SetPASVBoundPortMax, default=0};
	__property Inuseraccounts::TIdCustomUserManager* UserAccounts = {read=FUserAccounts, write=SetUserAccounts};
	__property AnsiString SystemType = {read=FSystemType, write=FSystemType};
	__property TIdOnBanner OnGreeting = {read=FOnGreeting, write=FOnGreeting};
	__property TIdOnBanner OnLoginSuccessBanner = {read=FOnLoginSuccessBanner, write=FOnLoginSuccessBanner};
	__property TIdOnBanner OnLoginFailureBanner = {read=FOnLoginFailureBanner, write=FOnLoginFailureBanner};
	__property TOnCacheChecksum OnMD5Cache = {read=FOnMD5Cache, write=FOnMD5Cache};
	__property TOnVerifyChecksum OnMD5Verify = {read=FOnMD5Verify, write=FOnMD5Verify};
	__property TIdOnBanner OnQuitBanner = {read=FOnQuitBanner, write=FOnQuitBanner};
	__property TOnCustomListDirectoryEvent OnCustomListDirectory = {read=FOnCustomListDirectory, write=FOnCustomListDirectory};
	__property TOnCustomPathProcess OnCustomPathProcess = {read=FOnCustomPathProcess, write=FOnCustomPathProcess};
	__property TOnAfterUserLoginEvent OnAfterUserLogin = {read=FOnAfterUserLogin, write=FOnAfterUserLogin};
	__property TOnDirectoryEvent OnChangeDirectory = {read=FOnChangeDirectory, write=FOnChangeDirectory};
	__property TOnGetFileSizeEvent OnGetFileSize = {read=FOnGetFileSize, write=FOnGetFileSize};
	__property TOnGetFileDateEvent OnGetFileDate = {read=FOnGetFileDate, write=FOnGetFileDate};
	__property TOnUserLoginEvent OnUserLogin = {read=FOnUserLogin, write=FOnUserLogin};
	__property TOnListDirectoryEvent OnListDirectory = {read=FOnListDirectory, write=FOnListDirectory};
	__property TOnDataPortBind OnDataPortBeforeBind = {read=FOnDataPortBeforeBind, write=FOnDataPortBeforeBind};
	__property TOnDataPortBind OnDataPortAfterBind = {read=FOnDataPortAfterBind, write=FOnDataPortAfterBind};
	__property TOnRenameFileEvent OnRenameFile = {read=FOnRenameFile, write=FOnRenameFile};
	__property TOnFileEvent OnDeleteFile = {read=FOnDeleteFile, write=FOnDeleteFile};
	__property TOnRetrieveFileEvent OnRetrieveFile = {read=FOnRetrieveFile, write=FOnRetrieveFile};
	__property TOnStoreFileEvent OnStoreFile = {read=FOnStoreFile, write=FOnStoreFile};
	__property TOnDirectoryEvent OnMakeDirectory = {read=FOnMakeDirectory, write=FOnMakeDirectory};
	__property TOnDirectoryEvent OnRemoveDirectory = {read=FOnRemoveDirectory, write=FOnRemoveDirectory};
	__property TIdOnFTPStatEvent OnStat = {read=FOnStat, write=FOnStat};
	__property TOnCombineFiles OnCombineFiles = {read=FOnCombineFiles, write=FOnCombineFiles};
	__property TOnCheckSumFile OnCRCFile = {read=FOnCRCFile, write=FOnCRCFile};
	__property TOnSetFileDateEvent OnSetCreationTime = {read=FOnSetCreationTime, write=FOnSetCreationTime};
	__property TOnSetFileDateEvent OnSetModifiedTime = {read=FOnSetModifiedTime, write=FOnSetModifiedTime};
	__property TOnCheckFileEvent OnFileExistCheck = {read=FOnFileExistCheck, write=FOnFileExistCheck};
	__property TOnSiteUMASK OnSiteUMASK = {read=FOnSiteUMASK, write=FOnSiteUMASK};
	__property TOnSiteCHMOD OnSiteCHMOD = {read=FOnSiteCHMOD, write=FOnSiteCHMOD};
	__property TIdOnPASV OnPASV = {read=FOnPASV, write=FOnPASV};
	__property Incommandhandlers::TInCommandHandlers* SITECommands = {read=FSITECommands, write=SetSITECommands};
	__property TIdMLSDAttrs MLSDFacts = {read=FMLSDFacts, write=FMLSDFacts, nodefault};
	__property TIdOnClientID OnClientID = {read=FOnClientID, write=FOnClientID};
	__property Inreply::TInReply* ReplyUnknownSITCommand = {read=FReplyUnknownSITECommand, write=SetReplyUnknownSITECommand};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInFTPServer(Classes::TComponent* AOwner)/* overload */ : Inexplicittlsclientserverbase::TIdExplicitTLSServer(AOwner) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TIdDataChannel : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	bool FNegotiateTLS;
	TInFTPServerContext* FControlContext;
	Intcpconnection::TInTCPConnection* FDataChannel;
	Inreplyrfc::TInReplyRFC* FErrorReply;
	TInFTPOperation FFtpOperation;
	Inreplyrfc::TInReplyRFC* FOKReply;
	Inreplyrfc::TInReplyRFC* FReply;
	TInFTPServer* FServer;
	bool FRequirePASVFromSameIP;
	bool FStopped;
	System::TObject* FData;
	void __fastcall SetErrorReply(const Inreplyrfc::TInReplyRFC* AValue);
	void __fastcall SetOKReply(const Inreplyrfc::TInReplyRFC* AValue);
	AnsiString __fastcall GetPeerIP();
	int __fastcall GetPeerPort(void);
	
public:
	__fastcall TIdDataChannel(bool APASV, TInFTPServerContext* AControlContext, const bool ARequirePASVFromSameIP, TInFTPServer* AServer, const int ADefaultDataPort);
	__fastcall virtual ~TIdDataChannel(void);
	void __fastcall InitOperation(const bool AConnectMode = false);
	void __fastcall SetPortParameters(const AnsiString AIP, const int APort, const Inglobal::TIdIPVersion AIPVersion);
	__property AnsiString PeerIP = {read=GetPeerIP};
	__property int PeerPort = {read=GetPeerPort, nodefault};
	__property bool Stopped = {read=FStopped, write=FStopped, nodefault};
	__property System::TObject* Data = {read=FData, write=FData};
	__property TInFTPServer* Server = {read=FServer};
	__property Inreplyrfc::TInReplyRFC* OKReply = {read=FOKReply, write=SetOKReply};
	__property Inreplyrfc::TInReplyRFC* ErrorReply = {read=FErrorReply, write=SetErrorReply};
};


class PASCALIMPLEMENTATION TInFTPServerContext : public Inftpservercontextbase::TInFTPServerContextBase 
{
	typedef Inftpservercontextbase::TInFTPServerContextBase inherited;
	
protected:
	int FRESTPos;
	TIdDataChannel* FDataChannel;
	AnsiString FAuthMechanism;
	Inftpcommon::TInFTPTransferType FDataType;
	Inftpcommon::TInFTPTransferMode FDataMode;
	int FDefaultDataPort;
	int FDataPort;
	unsigned FDataProtBufSize;
	Inftpcommon::TInFTPDataStructure FDataStruct;
	unsigned FPasswordAttempts;
	bool FPASV;
	bool FEPSVAll;
	bool FDataPortDenied;
	Inftpcommon::TInFTPDataPortSecurity FDataProtection;
	bool FDataPBSZCalled;
	Inftplistoutput::TInFTPFactOutputs FMLSOpts;
	bool FSSCNOn;
	TInFTPServer* FServer;
	TInFTPSecurityOptions* FUserSecurity;
	int FUMask;
	bool FMSDOSMode;
	AnsiString FQuitReply;
	int FZLibCompressionLevel;
	int FZLibWindowBits;
	int FZLibMemLevel;
	int FZLibStratagy;
	void __fastcall PortOnAfterBind(System::TObject* ASender);
	void __fastcall PortOnBeforeBind(System::TObject* ASender);
	void __fastcall SetUserSecurity(const TInFTPSecurityOptions* Value);
	void __fastcall CreateDataChannel(bool APASV = false);
	bool __fastcall IsAuthenticated(Incommandhandlers::TIdCommand* ASender);
	void __fastcall KillDataChannel(void);
	void __fastcall TerminateAndFreeDataChannel(void);
	virtual void __fastcall ReInitialize(void);
	
public:
	__fastcall virtual TInFTPServerContext(Intcpconnection::TInTCPConnection* AConnection, Inyarn::TInYarn* AYarn, Classes::TThreadList* AList);
	__fastcall virtual ~TInFTPServerContext(void);
	__property TIdDataChannel* DataChannel = {read=FDataChannel};
	__property TInFTPServer* Server = {read=FServer, write=FServer};
	__property TInFTPSecurityOptions* UserSecurity = {read=FUserSecurity, write=SetUserSecurity};
	__property AnsiString AuthMechanism = {read=FAuthMechanism, write=FAuthMechanism};
	__property Inftpcommon::TInFTPTransferType DataType = {read=FDataType, write=FDataType, nodefault};
	__property Inftpcommon::TInFTPTransferMode DataMode = {read=FDataMode, write=FDataMode, nodefault};
	__property int DataPort = {read=FDataPort, write=FDataPort, nodefault};
	__property unsigned DataProtBufSize = {read=FDataProtBufSize, write=FDataProtBufSize, nodefault};
	__property bool DataPBSZCalled = {read=FDataPBSZCalled, write=FDataPBSZCalled, nodefault};
	__property Inftpcommon::TInFTPDataStructure DataStruct = {read=FDataStruct, write=FDataStruct, nodefault};
	__property Inftpcommon::TInFTPDataPortSecurity DataProtection = {read=FDataProtection, write=FDataProtection, nodefault};
	__property unsigned PasswordAttempts = {read=FPasswordAttempts, write=FPasswordAttempts, nodefault};
	__property bool PASV = {read=FPASV, write=FPASV, nodefault};
	__property int RESTPos = {read=FRESTPos, write=FRESTPos, nodefault};
	__property Inftplistoutput::TInFTPFactOutputs MLSOpts = {read=FMLSOpts, write=FMLSOpts, nodefault};
	__property bool SSCNOn = {read=FSSCNOn, write=FSSCNOn, nodefault};
	__property bool MSDOSMode = {read=FMSDOSMode, write=FMSDOSMode, nodefault};
	__property int UMask = {read=FUMask, write=FUMask, nodefault};
	__property int ZLibCompressionLevel = {read=FZLibCompressionLevel, write=FZLibCompressionLevel, nodefault};
	__property int ZLibWindowBits = {read=FZLibWindowBits, write=FZLibWindowBits, nodefault};
	__property int ZLibMemLevel = {read=FZLibMemLevel, write=FZLibMemLevel, nodefault};
	__property int ZLibStratagy = {read=FZLibStratagy, write=FZLibStratagy, nodefault};
};


typedef void __fastcall (__closure *TIdOnGetCustomListFormat)(TInFTPServer* ASender, Inftplist::TInFTPListItem* AItem, AnsiString &VText);

#pragma option push -b-
enum TInTelnetState { tsData, tsCheckCR, tsIAC, tsWill, tsDo, tsWont, tsDont, tsNegotiate, tsNegotiateData, tsNegotiateIAC, tsInterrupt, tsInterruptIAC };
#pragma option pop

//-- var, const, procedure ---------------------------------------------------
#define DEF_DIRFORMAT (TInFTPDirFormat)(1)
static const bool Id_DEF_AllowAnon = false;
static const bool Id_DEF_PassStrictCheck = true;
static const bool DEF_FTP_IMPLICIT_FTP = false;
static const bool DEF_FTP_HIDE_INVALID_USER = true;
static const Shortint DEF_FTP_PASSWORDATTEMPTS = 0x3;
static const Word DEF_FTP_INVALIDPASS_DELAY = 0xbb8;
static const bool DEF_FTP_PASV_SAME_IP = true;
static const bool DEF_FTP_PORT_SAME_IP = true;
static const bool DEF_FTP_NO_RESERVED_PORTS = true;
static const bool DEF_FTP_BLOCK_ALL_PORTS = false;
static const bool DEF_FTP_DISABLE_SYST = false;
static const bool DEF_FTP_DISABLE_STAT = false;
static const bool DEF_FTP_REPORT_EX_MSG = false;
static const Shortint DEF_PASV_BOUND_MIN = 0x0;
static const Shortint DEF_PASV_BOUND_MAX = 0x0;
#define DEF_PATHPROCESSING (TInFTPPathProcessing)(2)
#define SYST_ID_UNIX "UNIX Type: L8"
#define SYST_ID_NT "Windows_NT"
extern PACKAGE AnsiString AAlwaysValidOpts[3];

}	/* namespace Inftpserver */
using namespace Inftpserver;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Inftpserver
